function T = dynamic_g2_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g2_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 274);

T = World_Economy_Cartel_Fracking_IRF.dynamic_g1_tt(T, y, x, params, steady_state, it_);

T(237) = T(40)+T(48)+params(25)*y(119)*exp(y(32))*params(6)*params(5)*params(5)*exp(params(5)*y(36));
T(238) = getPowerDeriv(T(9),T(10),3);
T(239) = T(142)+exp(y(13))*exp(y(13))*getPowerDeriv(exp(y(13)),params(3),2);
T(240) = T(5)*T(239);
T(241) = T(134)+T(133)+exp(y(41))*(T(132)+exp(y(41))*exp(y(41))*getPowerDeriv(exp(y(41)),T(11),3));
T(242) = y(67)*(-(T(81)*T(19)*T(16)*exp(T(1)*y(48))*(1-params(11))*params(3)*T(134)+T(5)*T(19)*T(83)*exp(T(1)*y(48))*(1-params(11))*params(3)*T(134)))+y(66)*(-(T(85)*T(3)*T(16)*exp(T(1)*y(48))*(1-params(11))*(1-params(3))*T(134)+T(17)*T(3)*T(83)*exp(T(1)*y(48))*(1-params(11))*(1-params(3))*T(134)));
T(243) = y(67)*(-(T(5)*T(19)*T(16)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(48))*T(134)))+y(66)*(-(T(17)*T(3)*T(16)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(48))*T(134)));
T(244) = T(145)+exp(y(13))*exp(y(13))*getPowerDeriv(exp(y(13)),params(3)-1,2);
T(245) = y(67)*(-(T(5)*(T(16)*T(52)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(48))*T(145)+T(19)*T(52)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(48))*T(82)*T(143))))+y(66)*(-(T(17)*(T(16)*T(52)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(48))*T(142)+T(3)*T(52)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(48))*T(82)*T(143))));
T(246) = y(67)*(-(T(81)*T(19)*T(53)*T(83)+T(19)*T(16)*T(53)*T(180)+T(81)*T(19)*T(53)*T(83)+T(5)*T(19)*T(53)*T(181)))+y(66)*(-(T(85)*T(3)*T(54)*T(83)+T(17)*T(3)*T(54)*T(181)+T(85)*T(3)*T(54)*T(83)+T(3)*T(16)*T(54)*T(185)));
T(247) = y(67)*(-(T(81)*T(19)*T(16)*T(52)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(48))+T(5)*T(19)*T(83)*T(52)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(48))))+y(66)*(-(T(17)*T(3)*T(83)*T(52)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(48))+T(85)*T(3)*T(16)*T(52)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(48))));
T(248) = y(67)*(-(T(5)*T(19)*T(16)*T(52)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(48))))+y(66)*(-(T(17)*T(3)*T(16)*T(52)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(48))));
T(249) = getPowerDeriv(T(63),T(10),3);
T(250) = T(139)+exp(y(105))*exp(y(105))*getPowerDeriv(exp(y(105)),T(11),2);
T(251) = (1-params(11))*(1-params(3))*exp(T(1)*y(110))*T(250);
T(252) = T(158)+T(157)+T(20)*(T(156)+T(20)*T(20)*getPowerDeriv(T(20),params(3),3));
T(253) = getPowerDeriv(T(59),T(1),3);
T(254) = getPowerDeriv(T(59),T(13),3);
T(255) = T(56)*T(158)*T(56)*T(57)*T(161)+T(69)*T(56)*T(252)+T(56)*T(158)*T(56)*T(57)*T(161)+T(56)*T(57)*(T(56)*T(158)*T(161)+T(56)*T(57)*T(56)*T(57)*T(254));
T(256) = T(56)*T(158)*T(161)*T(58)*T(197)+T(69)*T(158)*T(197)+T(56)*T(57)*T(161)*T(57)*T(197)+T(56)*T(57)*(T(161)*T(57)*T(197)+T(56)*T(57)*T(58)*T(197)*T(254));
T(257) = T(197)+exp(y(106))*exp(y(106))*getPowerDeriv(exp(y(106)),1-params(3),2);
T(258) = T(57)*T(197)*T(161)*T(58)*T(197)+T(69)*T(57)*T(257)+T(57)*T(197)*T(161)*T(58)*T(197)+T(56)*T(57)*(T(58)*T(197)*T(58)*T(197)*T(254)+T(161)*T(58)*T(257));
T(259) = getPowerDeriv(T(6),T(13),3);
T(260) = T(81)*T(142)*T(143)*T(148)+T(82)*T(81)*T(239)+T(81)*T(142)*T(143)*T(148)+T(3)*T(81)*(T(148)*T(240)+T(143)*T(143)*T(259));
T(261) = getPowerDeriv(T(6),T(1),3);
T(262) = getPowerDeriv(T(27),(-params(14)),2);
T(263) = T(168)*(-(params(9)*(T(166)+exp(y(14))*exp(y(14))*getPowerDeriv(exp(y(14)),1+params(8),2))/(1+params(8))))+T(167)*T(167)*T(262);
T(264) = T(28)*exp(y(15))*T(168)+T(28)*exp(y(15))*T(168);
T(265) = getPowerDeriv(T(25),(-params(14)),3);
T(266) = T(175)*T(76)*T(176)+T(77)*(-(params(9)*(T(174)+T(173)+T(4)*(T(172)+T(4)*T(4)*getPowerDeriv(T(4),1+params(8),3)))/(1+params(8))))+T(175)*T(76)*T(176)+T(76)*(T(175)*T(176)+T(76)*T(76)*T(265));
T(267) = T(180)+T(179)+T(4)*(T(178)+T(4)*T(4)*getPowerDeriv(T(4),1-params(3),3));
T(268) = T(3)*T(180)*T(3)*T(81)*T(148)+T(82)*T(3)*T(267)+T(3)*T(180)*T(3)*T(81)*T(148)+T(3)*T(81)*(T(148)*T(3)*T(180)+T(3)*T(81)*T(3)*T(81)*T(259));
T(269) = getPowerDeriv(T(89),(-params(14)),2);
T(270) = params(1)*(T(203)*(-(params(9)*(T(201)+exp(y(106))*exp(y(106))*getPowerDeriv(exp(y(106)),1+params(8),2))/(1+params(8))))+T(202)*T(202)*T(269));
T(271) = y(67)*(-(T(81)*T(19)*T(16)*T(12)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(48))+T(5)*T(19)*T(83)*T(12)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(48))));
T(272) = y(66)*(-(T(85)*T(3)*T(16)*T(12)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(48))+T(17)*T(3)*T(83)*T(12)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(48))));
T(273) = T(210)+exp(y(44))*exp(y(44))*T(176)+exp(y(44))*(exp(y(44))*T(176)+exp(y(44))*exp(y(44))*T(265));
T(274) = getPowerDeriv(exp(y(63)-y(49)),params(5)-1,3);

end
